/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;

public class PortPollAction
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private boolean loggingOn;

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "PortTable");
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "Port", objectArray);
        return i18NMsgFormat;
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
        if (statusModelInfo == null || !(statusModelInfo.get("PortInfo.PortState") instanceof Integer)) {
            statusAndExplain.statType = StatusType.UNKNOWN;
            statusAndExplain.explain = new I18NString(bundleName, "MissingPollData");
        } else {
            int n = (Integer)statusModelInfo.get("PortInfo.PortState");
            Object[] objectArray = statusModelInfo.getIndexes();
            statusAndExplain = this.evaluatePortStatus(n, objectArray);
        }
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    private StatusAndExplain evaluatePortStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "PortStatusDisabled", objectArray);
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.NORMAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "PortStatusBlocking", objectArray);
                break;
            }
            case 5: {
                statusAndExplain.statType = StatusType.NORMAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "PortStatusForwarding", objectArray);
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "PortStatusListening", objectArray);
                break;
            }
            case 4: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "PortStatusLearning", objectArray);
                break;
            }
            case 6: {
                statusAndExplain.statType = StatusType.CRITICAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "PortStatusBroken", objectArray);
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "PortStatusUnknown", objectArray);
            }
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NString explain;

        StatusAndExplain() {
            PortPollAction.this = PortPollAction.this;
        }
    }
}

